<?php
  include ('../accesscontrol.php');

  if ($is_logged_in == False)
  {
    echo "You are not yet logged in.";
    exit();
  }

  include ('../header.html');
  include ('../constants.php');           //nedded because of "../footer.html" statements

  //check if the form has been submitted
  if (isset($_POST['submit11']))
  {
    $name1 = mysqli_real_escape_string_mimic($_POST["name"]);

    $name1 = str_replace(" ", "_", $name1);
    $name1 = str_replace("#", "nr", $name1);
    $name1 = str_replace(chr(39), "~", $name1);

    $sex1 = strtolower(mysqli_real_escape_string_mimic($_POST["sex"]));

    $month1 = intval(mysqli_real_escape_string_mimic($_POST["month"]));
    $day1 = intval(mysqli_real_escape_string_mimic($_POST["day"]));
    $year1 = intval(mysqli_real_escape_string_mimic($_POST["year"]));

    $hour1 = intval(mysqli_real_escape_string_mimic($_POST["hour"]));
    $minute1 = intval(mysqli_real_escape_string_mimic($_POST["minute"]));
    $amorpm1 = mysqli_real_escape_string_mimic($_POST["amorpm"]);

    $long_deg1 = mysqli_real_escape_string_mimic($_POST["long_deg"]);
    $long_min1 = mysqli_real_escape_string_mimic($_POST["long_min"]);
    $long_dir1 = strtoupper(mysqli_real_escape_string_mimic($_POST["ew"]));
    $ew1 = strtoupper(mysqli_real_escape_string_mimic($_POST["ew"]));

    $lat_deg1 = mysqli_real_escape_string_mimic($_POST["lat_deg"]);
    $lat_min1 = mysqli_real_escape_string_mimic($_POST["lat_min"]);
    $lat_dir1 = strtoupper(mysqli_real_escape_string_mimic($_POST["ns"]));
    $ns1 = strtoupper(mysqli_real_escape_string_mimic($_POST["ns"]));

    $city1 = stripslashes(mysqli_real_escape_string_mimic($_POST["city"]));
    $county1 = stripslashes(mysqli_real_escape_string_mimic($_POST["county"]));
    $country1 = stripslashes(mysqli_real_escape_string_mimic($_POST["cntry"]));
    $county_index1 = stripslashes(mysqli_real_escape_string_mimic($_POST["county_index"]));

    $the_lng1 = mysqli_real_escape_string_mimic($_POST["the_lng"]);
    $the_lat1 = mysqli_real_escape_string_mimic($_POST["the_lat"]);

    $my_error = "";

    include("validation_class.php");

    //error check
    $my_form = new Validate_fields;

    $my_form->check_4html = true;

    $my_form->add_text_field("Name", $name1, "text", "y", 40);
    $my_form->add_text_field("Sex", $sex, "text", "y", 1);

    $my_form->add_text_field("Month", $month1, "text", "y", 2);
    $my_form->add_text_field("Day", $day1, "text", "y", 2);
    $my_form->add_text_field("Year", $year1, "text", "y", 4);

    $my_form->add_text_field("Hour", $hour1, "text", "y", 2);
    $my_form->add_text_field("Minute", $minute1, "text", "y", 2);

    //find the current year
    //$current_year = gmdate("Y");
    //$cutoff_year = $current_year - 1 - 18;

    if ($month1 != "" And $day1 != "" And $year1 != "")
    {
      if (!$date = checkdate($month1, $day1, $year1)) { $my_error .= "The date of birth you entered is not valid.<br>"; }
    }

    //if (($year1 < 1200) Or ($year1 >= 2400)) { $my_error .= "Birth year person - please enter a year between 1200 and 2399.<br>"; }
    //if (($year1 < 1936) Or ($year1 > $cutoff_year))
    if ($year1 < 1200 Or $year1 >= 2400) { $my_error .= "Birth year must be between 1200 and 2400<br />"; }

    if ((intval($hour1) < 1) Or (intval($hour1) > 12)) { $my_error .= "Birth hour must be between 1 and 12.<br>"; }
    if (is_numeric($hour1) == False) { $my_error .= "Birth hour must be a numeric value between 1 and 12.<br>"; }
    if ($minute1 < 0 Or $minute1 > 59) { $my_error .= "Birth minute must be between 0 and 59.<br>"; }
    if ($amorpm1 == "") { $my_error .= "Please tell me AM, PM, or birth time unknown.<br>"; }
    if (is_numeric($minute1) == False) { $my_error .= "Birth minute must be a numeric value between 0 and 59.<br>";     }

    if (($long_deg1 < 0) Or ($long_deg1 > 179)) { $my_error .= "Longitude degrees must be between 0 and 179.<br>"; }
    if (($long_min1 < 0) Or ($long_min1 > 59)) { $my_error .= "Longitude minutes must be between 0 and 59.<br>"; }
    if (($lat_deg1 < 0) Or ($lat_deg1 > 90)) { $my_error .= "Latitude degrees must be between 0 and 90.<br>"; }
    if (($lat_min1 < 0) Or ($lat_min1 > 59)) { $my_error .= "Latitude minutes must be between 0 and 59.<br>"; }
    if ($ew1 != 'E' And $ew1 != 'W') { $my_error .= "Longitude must be either E or W.<br>"; }
    if ($ns1 != 'N' And $ns1 != 'S') { $my_error .= "Latitude must be either N or S.<br>"; }
    if (is_numeric($long_deg1) == False) { $my_error .= "Longitude degrees must be a numeric value between 0 and 180.<br>"; }
    if (is_numeric($long_min1) == False) { $my_error .= "Longitude minutes must be a numeric value between 0 and 59.<br>"; }
    if (is_numeric($lat_deg1) == False) { $my_error .= "Latitude degrees must be a numeric value between 0 and 66.<br>"; }
    if (is_numeric($lat_min1) == False) { $my_error .= "Latitude minutes must be a numeric value between 0 and 59.<br>"; }
    if ($long_deg1 == 0 And $long_min1 == 0 And $lat_deg1 == 0 And $lat_min1 == 0) { $my_error .= "Please re-select your city and give it time to process.<br>"; }

    if ($my_error != "")
    {
      echo "<div id='content'>";
      echo "<h1>Your Data Entry</h1>";

      $error = $my_form->create_msg();
      echo "<strong>Error! - The following error(s) occurred:</font><br>";

      if ($error)
      {
        echo $error . $my_error;
      }
      else
      {
        echo $error . "<br>" . $my_error;
      }

      echo "</strong>";
      echo "<p>&nbsp;</p>";
      echo "</div>";
    }
    else
    {
      $date_now = date ("Y-m-d");           //take all information and pass it to calculation script

      $ubt1 = 0;

      if (trim($amorpm1) == "PM")
      {
        if ($hour1 != 12) { $hour1 = $hour1 + 12; }
      }
      elseif (trim($amorpm1) == "AM")
      {
        if ($hour1 == 12) { $hour1 = 0; }
      }
      else
      {
        $hour1 = 12;
        $minute1 = 0;

        $ubt1 = 1;
      }


      $east_west = 1;
      if ($long_dir1 == "W") { $east_west = -1; }

      $north_south = 1;
      if ($lat_dir1 == "S") { $north_south = -1; }

      //==============================================================================

      //get the time zone for the longitude and latitude provided
      include('get_time_zone.php');

      //==============================================================================


      $emailText = "Name               = " . stripslashes(str_replace("~", chr(39), $name1)) . "<br><br>";

      $emailText .= "Sex                = " . stripslashes($sex1) . "<br><br>";

      $emailText .= "Month             = " . stripslashes($month1) . "<br>";
      $emailText .= "Day               = " . stripslashes($day1) . "<br>";
      $emailText .= "Year              = " . stripslashes($year1) . "<br><br>";

      $emailText .= "Hour              = " . stripslashes($hour1) . "<br>";
      $emailText .= "Minute            = " . stripslashes($minute1) . "<br><br>";

      $emailText .= "Longitude deg     = " . stripslashes($long_deg1) . "<br>";
      $emailText .= "E or W            = " . stripslashes($long_dir1) . "<br>";
      $emailText .= "Longitude min     = " . stripslashes($long_min1) . "<br><br>";

      $emailText .= "Latitude deg      = " . stripslashes($lat_deg1) . "<br>";
      $emailText .= "N or S            = " . stripslashes($lat_dir1) . "<br>";
      $emailText .= "Latitude min      = " . stripslashes($lat_min1) . "<br><br>";

      $emailText .= "City              = " . stripslashes($city1) . "<br>";
      $emailText .= "County            = " . stripslashes($county1) . "<br>";
      $emailText .= "Country           = " . stripslashes($the_country_code) . "<br>";
      $emailText .= "Admin 1           = " . stripslashes($the_admin1) . "<br>";        //could be county name
      $emailText .= "Admin 2           = " . stripslashes($the_admin2) . "<br><br>";

      $emailText .= "Longitude         = " . stripslashes($the_lng1) . "<br>";
      $emailText .= "Latitude          = " . stripslashes($the_lat1) . "<br><br>";

      $emailText .= "Time zone         = " . $the_tz . "<br>";
      $emailText .= "Time type         = " . $the_time_type . "<br>";
      $emailText .= "DST (1 = yes)     = " . $the_dst . "<br><br>";

      $emailText .= "<b>NOTE:</b> Please be aware that historical time zones for years<br>";
      $emailText .= "prior to 1970 are sometimes difficult to correctly ascertain.<br>";
      $emailText .= "It is possible that the above time zone is 1 hour off because<br>";
      $emailText .= " of the mess that Daylight Saving Time has caused prior to 1970.<br><br>";

      $emailText .= "Chosen country code   = " . $the_cntry_code . "<br>";
      $emailText .= "Chosen time zone city = " . $the_zone_name . "<br><br>";

      $emailText .= "Date of record = $date_now \n\n";

      echo "<center><br>I have recorded the following data:<br><br>" . $emailText . "<br><br></center>";


      send_to_debug_file_gn($city1);
      send_to_debug_file_gn($county1);
      send_to_debug_file_gn($the_country_code);
      send_to_debug_file_gn($the_admin1);
      send_to_debug_file_gn($the_admin2);
      send_to_debug_file_gn($long_deg1 . $long_dir1 . $long_min1);
      send_to_debug_file_gn($lat_deg1 . $lat_dir1 . $lat_min1);
      send_to_debug_file_gn($the_tz);
      send_to_debug_file_gn($the_time_type);
      send_to_debug_file_gn("==========================");


      //$sw = "/online_calcs/scripts/add_to_db_1.php";
      $sw = "add_to_db_1.php";
      $sw .= "?ss=4&n=" . stripslashes($name1);
      $sw .= "&sex=" . $sex1;
      $sw .= "&m=" . $month1;
      $sw .= "&d=" . $day1;
      $sw .= "&y=" . $year1;
      $sw .= "&h=" . $hour1;
      $sw .= "&min=" . $minute1;
      $sw .= "&tz=" . $the_tz;
      $sw .= "&long_deg=" . $long_deg1;
      $sw .= "&long_min=" . $long_min1;
      $sw .= "&ew=" . strtolower($long_dir1);
      $sw .= "&lat_deg=" . $lat_deg1;
      $sw .= "&lat_min=" . $lat_min1;
      $sw .= "&ns=" . strtolower($lat_dir1);
      $sw .= "&ubt=" . $ubt1;

      echo "<center><br><a href='" . $sw . "' target='_blank'>Click here</a> to add this data to your AstroWin database<br><br></center>";
    }
  }

  include ('./footer.html');

  exit();


Function mysqli_real_escape_string_mimic($inp)
{
  if(is_array($inp))
    return array_map(__METHOD__, $inp);

  $temp1 = str_replace("<", "[", $inp);
  $temp2 = str_replace(">", "]", $temp1);

  $temp1 = str_replace("[br]", "<br />", $temp2);
  $temp2 = str_replace("[br /]", "<br />", $temp1);

  if(!empty($temp2) && is_string($temp2))
  {
    return str_replace(array('\\', "\0", "\n", "\r", "'", '"', "\x1a"), array('\\\\', '\\0', '\\n', '\\r', "\\'", '\\"', '\\Z'), $temp2);
  }

  return $temp2;
}


Function send_to_debug_file_gn($t)
{
  $fh = fopen("debug_gn.txt", "a+");

  fwrite($fh, $t . "\n");

  fclose($fh);
}

?>


