<?php
  header('Content-type: application/json');

  if (!isset($_GET['okay']))                //is there data?
  {
    echo 'There is no direct access to this script';

    exit();
  }

  $longitude = trim(safeEscapeString($_GET["longitude"]));
  $latitude = trim(safeEscapeString($_GET["latitude"]));

//------------------------------------------------------------------------------

  $longi = abs($longitude);
  $long_deg = floor($longi);
  $long_min = sprintf("%.0f", ($longi - $long_deg) * 60);

  $long_dir = "W";
  if ($longitude >= 0) { $long_dir = "E"; }

  if ($long_min == 60)
  {
    $long_deg = $long_deg + 1;
    $long_min = 0;
  }

//------------------------------------------------------------------------------

  $lati = abs($latitude);
  $lat_deg = floor($lati);
  $lat_min = sprintf("%.0f", ($lati - $lat_deg) * 60);

  $lat_dir = "S";
  if ($latitude >= 0) { $lat_dir = "N"; }

  if ($lat_min == 60)
  {
    $lat_deg = $lat_deg + 1;
    $lat_min = 0;
  }

//------------------------------------------------------------------------------

  $json = array('error_found' => false, 'found' => true, 'long_deg' => $long_deg, 'long_min' => $long_min, 'long_dir' => $long_dir, 'lat_deg' => $lat_deg, 'lat_min' => $lat_min, 'lat_dir' => $lat_dir);

  echo json_encode($json);

  exit();


Function Convert_DecimalDegrees_to_DegMin($geo_coord)
{
  $the_dt = array();

  $x = abs($geo_coord);

  $dg = floor($x);

  $fraction = $x - $dg;

  $mm = round($fraction * 60);

  if ($mm == 60)
  {
    $mm = 0;
    $dg++;
  }

  $the_dt[0] = $dg;
  $the_dt[1] = $mm;

  return $the_dt;
}


Function safeEscapeString($inp)
{
  if(is_array($inp))
    return array_map(__METHOD__, $inp);

  $temp1 = str_replace("<", "[", $inp);
  $temp2 = str_replace(">", "]", $temp1);

  $temp1 = str_replace("[br]", "<br />", $temp2);
  $temp2 = str_replace("[br /]", "<br />", $temp1);

  if(!empty($temp2) && is_string($temp2))
  {
    return str_replace(array('\\', "\0", "\n", "\r", "'", '"', "\x1a"), array('\\\\', '\\0', '\\n', '\\r', "\\'", '\\"', '\\Z'), $temp2);
  }

  return $temp2;
}


Function send_to_debug_file($t)
{
  $fh = fopen("debug.txt", "a+");

  fwrite($fh, $t . "\n");

  fclose($fh);
}

?>
